/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.structurecompass.client.screen.widget.StructureListWidget;
import com.mrbysco.structurecompass.compat.gamestages.GameStagesHelper;
import com.mrbysco.structurecompass.network.PacketHandler;
import com.mrbysco.structurecompass.network.message.SetStructureMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.network.PacketDistributor;

public class CompassScreen
extends Screen {
    private static final int PADDING = 6;
    private StructureListWidget structureWidget;
    private StructureListWidget.ListEntry selected = null;
    private int listWidth;
    private List<ResourceLocation> structures;
    private final List<ResourceLocation> unsortedStructures;
    private Button loadButton;
    private final InteractionHand usedHand;
    private final ItemStack compassStack;
    private final int buttonMargin = 1;
    private final int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private EditBox search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    public CompassScreen(InteractionHand hand, ItemStack compass, List<ResourceLocation> allStructures) {
        super((Component)new TranslatableComponent("structurecompass:compass.screen"));
        this.usedHand = hand;
        this.compassStack = compass;
        ArrayList<ResourceLocation> structureList = new ArrayList<ResourceLocation>();
        for (ResourceLocation id : allStructures) {
            if (id == null) continue;
            structureList.add(id);
        }
        if (ModList.get().isLoaded("gamestages")) {
            structureList.removeIf(location -> !GameStagesHelper.doesPlayerHaveRequiredStage(location));
        }
        Collections.sort(structureList);
        this.structures = Collections.unmodifiableList(structureList);
        this.unsortedStructures = Collections.unmodifiableList(allStructures);
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        int centerWidth = this.f_96543_ / 2;
        for (ResourceLocation structureLocation : this.structures) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().m_92895_(structureLocation.toString()) + 10);
        }
        this.listWidth = Math.max(Math.min(this.listWidth, this.f_96543_ / 3), 200);
        this.listWidth += this.listWidth % this.numButtons != 0 ? this.numButtons - this.listWidth % this.numButtons : 0;
        int structureWidth = this.f_96543_ - this.listWidth - 18;
        int closeButtonWidth = Math.min(structureWidth, 200);
        int y = this.f_96544_ - 20 - 6;
        this.m_142416_((GuiEventListener)new Button(centerWidth - closeButtonWidth / 2 + 6, y, closeButtonWidth, 20, (Component)new TranslatableComponent("gui.cancel"), b -> this.m_7379_()));
        this.loadButton = new Button(centerWidth - closeButtonWidth / 2 + 6, y -= 24, closeButtonWidth, 20, (Component)new TranslatableComponent("structurecompass.screen.selection.select"), b -> {
            if (this.selected != null) {
                PacketHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new SetStructureMessage(this.usedHand, this.selected.getStructureLocation()));
            }
        });
        this.m_142416_((GuiEventListener)this.loadButton);
        this.search = new EditBox(this.getFontRenderer(), centerWidth - this.listWidth / 2 + 6 + 1, y -= 20, this.listWidth - 2, 14, (Component)new TranslatableComponent("structurecompass.screen.search"));
        int fullButtonHeight = 32;
        int n = this.search.f_93621_;
        Objects.requireNonNull(this.getFontRenderer());
        this.structureWidget = new StructureListWidget(this, this.f_96543_, fullButtonHeight, n - 9 - 6);
        this.structureWidget.m_93507_(0);
        this.m_7787_((GuiEventListener)this.search);
        this.m_7787_((GuiEventListener)this.structureWidget);
        this.search.m_94178_(false);
        this.search.m_94190_(true);
        if (this.compassStack.m_41782_() && this.compassStack.m_41783_().m_128441_("structurecompass:structureName")) {
            String structure = this.compassStack.m_41783_().m_128461_("structurecompass:structureName");
            this.search.m_94144_(structure);
        }
        int width = this.listWidth / this.numButtons;
        int x = centerWidth + 6 - width;
        SortType.A_TO_Z.button = new Button(x, 6, width - 1, 20, SortType.A_TO_Z.getButtonText(), b -> this.resortStructures(SortType.A_TO_Z));
        this.m_142416_((GuiEventListener)SortType.A_TO_Z.button);
        SortType.Z_TO_A.button = new Button(x += width + 1, 6, width - 1, 20, SortType.Z_TO_A.getButtonText(), b -> this.resortStructures(SortType.Z_TO_A));
        this.m_142416_((GuiEventListener)SortType.Z_TO_A.button);
        this.resortStructures(SortType.A_TO_Z);
        this.updateCache();
    }

    public void m_96624_() {
        this.search.m_94120_();
        this.structureWidget.m_6987_((AbstractSelectionList.Entry)this.selected);
        if (!this.search.m_94155_().equals(this.lastFilterText)) {
            this.reloadStructures();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadStructures();
            if (this.sortType == SortType.A_TO_Z) {
                Collections.sort(this.structures);
            } else if (this.sortType == SortType.Z_TO_A) {
                this.structures.sort(Collections.reverseOrder());
            }
            this.checkStages();
            this.structureWidget.refreshList();
            if (this.selected != null) {
                this.selected = this.structureWidget.m_6702_().stream().filter(e -> e == this.selected).findFirst().orElse(null);
                this.updateCache();
            }
            this.sorted = true;
        }
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildStructureList(Consumer<T> ListViewConsumer, Function<ResourceLocation, T> newEntry) {
        this.structures.forEach(mod -> ListViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((ResourceLocation)mod)));
    }

    private void reloadStructures() {
        this.structures = this.unsortedStructures.stream().filter(struc -> StringUtils.toLowerCase((String)struc.toString()).contains(StringUtils.toLowerCase((String)this.search.m_94155_()))).collect(Collectors.toList());
        this.checkStages();
        this.lastFilterText = this.search.m_94155_();
    }

    private void checkStages() {
        if (ModList.get().isLoaded("gamestages")) {
            this.structures.removeIf(location -> !GameStagesHelper.doesPlayerHaveRequiredStage(location));
        }
    }

    private void resortStructures(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.f_93623_ = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.structureWidget.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        TranslatableComponent text = new TranslatableComponent("structurecompass.screen.search");
        Font font = this.getFontRenderer();
        int n = this.f_96543_ / 2 + 6;
        int n2 = this.search.f_93621_;
        Objects.requireNonNull(this.getFontRenderer());
        CompassScreen.m_93215_((PoseStack)poseStack, (Font)font, (Component)text, (int)n, (int)(n2 - 9 - 2), (int)0xFFFFFF);
        this.search.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public Font getFontRenderer() {
        return this.f_96547_;
    }

    public void setSelected(StructureListWidget.ListEntry entry) {
        this.selected = entry == this.selected ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        if (this.selected == null) {
            this.loadButton.f_93623_ = false;
            return;
        }
        this.loadButton.f_93623_ = true;
    }

    public void m_6574_(Minecraft mc, int width, int height) {
        String s = this.search.m_94155_();
        SortType sort = this.sortType;
        StructureListWidget.ListEntry selected = this.selected;
        this.m_6575_(mc, width, height);
        this.search.m_94144_(s);
        this.selected = selected;
        if (!this.search.m_94155_().isEmpty()) {
            this.reloadStructures();
        }
        if (sort != SortType.NORMAL) {
            this.resortStructures(sort);
        }
        this.updateCache();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(null);
    }

    private static enum SortType {
        NORMAL,
        A_TO_Z,
        Z_TO_A;

        Button button;

        Component getButtonText() {
            return new TranslatableComponent("structurecompass.screen.search." + this.name().toLowerCase(Locale.ROOT));
        }
    }
}

